'==========================================================================
' NAME: WebHostingHelpMethods
' DESCRIPTION:	This script file contains generic help function and Sub
'				routines for scripting automation of web hosting
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================



Public Function CreatePath(strPath)
'***********************************************************
'	Name: CreatePath
'	Purpose: Recursively creates a folder structure
'	Inputs:	strPath - Full path of the folder structure

'	Output: Full path of the content folder
'	Comments: Since this uses the FileSystemObject
'				it can only be used to create local
'				folders
'**********************************************************
	Dim oFSO
	Dim oFolder
	Dim strReturn
	Dim strDriveName
	'Instantiate FileSystemObject
	Set oFSO = CreateObject("Scripting.FileSystemObject")
	'Check if Drive Exists
	strDriveName =oFSO.GetDriveName(strPath)
	If oFSO.DriveExists(strDriveName) Then
		'Loop through the folder structure until all folders exist
		Do Until oFSO.FolderExists(strPath) = True
			'If the parent folder exisits, create the child
			If oFSO.FolderExists(oFSO.GetParentFolderName(strPath)) Then
				set oFolder = oFSO.CreateFolder(strPath)
				'Return the created folder structure
				strReturn = oFolder.Path
			Else
				'Send the parent to this function for creation
				strReturn = CreatePath(oFSO.GetParentFolderName(strPath))
			End If
		Loop
	Else
		'Throw an Error
		WScript.Echo "Drive " & oFSO.GetDriveName(strPath) & " doesn't exist.  Can't create " & strPath & ". Script Aborting!"
		WScript.Quit
	End If
	CreatePath = strReturn
End Function

Public Function CreateWMIServiceInstance(strComputer)
'===================================================
'	NAME:	CreateWMIServiceInstance
'	IN:		strComputer - Name of computer to connect to
'	OUT:	Instance of WMI \ROOT\CMIV2 namespace
'	
'===================================================
	Dim objWMIService 
	'Create the service setting impersonation level
	'to use the credentials of the caller
	'and authentication level to encrypt COM packets for remote calls
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate,authenticationLevel=pktPrivacy}\\" & strComputer & "\root\CIMV2")
	Set CreateWMIServiceInstance = objWMIService

End Function

Function RandomPassword(intNumChars)
'===================================================
'	NAME:	RandomPassword
'	IN:		intNumChars - Length of Password
'	OUT:	Random Password String
'	
'===================================================
	Dim strPWD
	Dim strRandChars
	Dim intULim
	Dim intLLim
	Dim intSelectChar
	Dim I
	strPWD = ""
	strRandChars = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789!@#$%^&"
	intULim = Len(strRandChars)
	intLLim = 1
	Randomize
	For I = 1 To intNumChars
	     intSelectChar = Int((intULim - intLLim + 1) * Rnd + intLLim)
	     strPWD = strPWD & Mid(strRandChars,intSelectChar,1)
	Next
	RandomPassword = strPWD


End Function

